<?xml version="1.0" encoding="utf-8" ?> 

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform' xmlns:HTML='http://www.w3.org/Profiles/XHTML-transitional' xmlns:dt='urn:schemas-microsoft-com:datatypes'>

	<xsl:output method='html'/>

	

	<xsl:include href="../../apt/views/spreadsheetview.xslt"/>



	<xsl:template match='@* | node()'>

		<xsl:copy><xsl:apply-templates select="@* | node()"/></xsl:copy>

	</xsl:template>

	

	<xsl:strip-space elements="*"/>



	<xsl:template match='/case'>

		<xsl:call-template name="spreadsheet_start">

			<xsl:with-param name="nohandler">true</xsl:with-param>

		</xsl:call-template>

	</xsl:template>

	

	<xsl:template name="spreadsheet_columns_def">

		<xsl:param name="hidden"/>

		<xsl:call-template name="spreadsheet_column">

			<xsl:with-param name="name">Type</xsl:with-param>

			<xsl:with-param name="width">120px</xsl:with-param>

			<xsl:with-param name="hidden" select="$hidden"/>

		</xsl:call-template>

		<xsl:call-template name="spreadsheet_column">

			<xsl:with-param name="name">Sub Type</xsl:with-param>

			<xsl:with-param name="width">60px</xsl:with-param>

			<xsl:with-param name="hidden" select="$hidden"/>

		</xsl:call-template>

		<xsl:call-template name="spreadsheet_column">

			<xsl:with-param name="name">Source</xsl:with-param>

			<xsl:with-param name="width">30%</xsl:with-param>

			<xsl:with-param name="type"></xsl:with-param>

			<xsl:with-param name="hidden" select="$hidden"/>

		</xsl:call-template>

		<xsl:call-template name="spreadsheet_column">

			<xsl:with-param name="name">Data</xsl:with-param>

			<xsl:with-param name="width">70%</xsl:with-param>

			<xsl:with-param name="minwidth">200px</xsl:with-param>

			<xsl:with-param name="hidden" select="$hidden"/>

		</xsl:call-template>

	</xsl:template>

	

	<xsl:template name="spreadsheet_rows_def">

		<xsl:param name="hidden"/>

		<xsl:for-each select='event'>

			<xsl:call-template name="spreadsheet_row">

				<xsl:with-param name="hidden" select="$hidden"/>

				<xsl:with-param name="hasChild" select="event"/>

				<xsl:with-param name="expanded" select='event'/> <!-- descendant-or-self::event[@current="true"]'/> -->

			</xsl:call-template>

		</xsl:for-each>

	</xsl:template>

	

	<xsl:template name="spreadsheet_values_def">

		<xsl:param name="hasChild"/>

		<xsl:param name="expanded"/>

		<xsl:call-template name="spreadsheet_value">

			<xsl:with-param name="value"><xsl:value-of select='@eventType'/><xsl:if test='@current="true"'>*</xsl:if></xsl:with-param>

			<xsl:with-param name="handleIndent">yes</xsl:with-param>

			<xsl:with-param name="parentList" select='ancestor::*/parent::*'/>

			<xsl:with-param name="hasChild" select="$hasChild"/>

			<xsl:with-param name="expanded" select="$expanded"/>

		</xsl:call-template>

		<xsl:call-template name="spreadsheet_value">

			<xsl:with-param name="value" select="string(@eventSubType)"/>

		</xsl:call-template>

		<xsl:call-template name="spreadsheet_value">

			<xsl:with-param name="value"><xsl:apply-templates select='source'/></xsl:with-param>

		</xsl:call-template>

		<xsl:call-template name="spreadsheet_value">

			<xsl:with-param name="value"><xsl:apply-templates select='self::*'/></xsl:with-param>

		</xsl:call-template>

		<xsl:attribute name="nodeid">

			<xsl:value-of select="@id"/>

		</xsl:attribute>

	</xsl:template>

	

	<xsl:template match='source[@elementTagName]'>

		<span class='sourceType'><xsl:value-of select='@elementTagName'/></span><span class='sourceAttribute'>

		(<xsl:if test='@elementId'>id=<xsl:value-of select='@elementId'/><xsl:if test='@elementIdIndex'>[<xsl:value-of select='@elementIdIndex'/>]</xsl:if></xsl:if>

		<xsl:if test='@elementName'><xsl:if test='@elementId'>,</xsl:if>name=<xsl:value-of select='@elementName'/><xsl:if test='@elementNameIndex'>[<xsl:value-of select='@elementNameIndex'/>]</xsl:if></xsl:if>

		<xsl:if test='@path'><xsl:if test='@elementName or @elementId'>,</xsl:if>path=<xsl:value-of select='@path'/></xsl:if>)</span>

		<xsl:variable name='winIndex' select='source/@winIndex'/>

		<xsl:if test='$winIndex'>

		<div>

			<xsl:for-each select='preceding::event[@winIndex=$winIndex][last()]'>

				<xsl:call-template name='window'/>

			</xsl:for-each>			

		</div>

		</xsl:if>

	</xsl:template>

		

	<xsl:template match='source[@winIndex]'>

		<xsl:call-template name='window'/>

	</xsl:template>



	<xsl:template name='window'>	

		<span class='sourceType'>Window</span><span class='sourceAttribute'><xsl:value-of select='@winPointer'/>

			(<xsl:if test='@winId'>id=<xsl:value-of select='@winId'/></xsl:if>

			<xsl:if test='@name'><xsl:if test='@winId'>,</xsl:if>name=<xsl:value-of select='@name'/></xsl:if>

			<xsl:if test='@url'><xsl:if test='@name or @winId'>,</xsl:if>url=<xsl:value-of select='@url'/></xsl:if>)</span>

	</xsl:template>	

		

	<xsl:template match='event[@eventType = "keyboard"]'>

		<xsl:value-of select='@keys'/>

	</xsl:template>



	<xsl:template match='event[@eventType = "mouse"]'>

		x=<xsl:value-of select='@x'/>, y=<xsl:value-of select='@y'/>

	</xsl:template>



	<xsl:template match='event[@eventType = "navigate"]'>

		<xsl:value-of select='@url'/>

	</xsl:template>

</xsl:stylesheet>

